#include "pch.h"

#include "ChangeGroupAction.h"
#include "../Links.h"
#include "../LinksManager.h"
#include "../Misc.hpp"
#include "../Log.h"
#include "../Common.hpp"


CChangeGroupAction::CChangeGroupAction(const char* aGroupAction, const char* aLinksMask)
	: groupAction(aGroupAction), linksMask(aLinksMask)
{

}


CChangeGroupAction::~CChangeGroupAction()
{

}


void CChangeGroupAction::invoke() throw(CActionException) {
	// check group action
	if (groupAction.size() < 2 || (groupAction[0] != '-' && groupAction[0] != '+')) {
		throw CActionException( string("invalid group action: '") + groupAction + "'" );
	}
	// check links mask
	if (linksMask.size() < 1) {
		throw CActionException( string("invalid links mask: '") + linksMask + "'" );
	}
	// read action flag (add or remove group)
	bool	addGroup = (groupAction[0] == '+');
	// read group name
	string	groupName( groupAction.c_str() + 1 );

	// prepare counter and log
	int	counter = 0;
	g_vars.m_log << CLog::ResetSingle( new CLog::StdErr() );

	LinksManagerPtr	linksManager = CLinksManager::getInstance();
	for (CLinksManager::CIterator	it = linksManager->begin();
		 it != linksManager->end(); ++it)
	{
		LinkPtr	link = (*it);
		// check link agains mask
		tstring	addr = link->getAddress().toString();
		if (CheckMask( addr.c_str(), linksMask.c_str() )) {
			// change group
			if (addGroup) {
				if (!link->canAccessGroup( groupName )) {
					link->addGroup( groupName );
					++counter;

					g_vars.m_log << "group added to " << addr << TEXT_EOL;
				}
			} else {
				if (link->canAccessGroup( groupName )) {
					link->removeGroup( groupName );
					++counter;

					g_vars.m_log << "group removed from " << addr << TEXT_EOL;
				}
			}
		}
	}

	if (counter > 0) {
		linksManager->affectLinks();
	} else {
		g_vars.m_log << "no links found to change group\n";
	}

	g_vars.m_log << CLog::Pop( 3 );
}
